//======================================
//DayWindow.js
//======================================
/*:
 * @plugindesc 日付ウィンドウ表示処理
 * @author TRS
 *
 * @param --スイッチ・変数設定--
 * @desc セパレータ
 *
 * @param 朝夜変更スイッチ
 * @desc 朝……スイッチOFF 夜……スイッチON
 * @type switch
 * @default 101
 *
 * @param 日付格納変数
 * @desc 日目で表示する数値が格納されてる変数番号
 * @type variable
 * @default 103
 *
 * @param 日付ウィンドウ表示スイッチ
 * @desc 日付ウィンドウ表示・非表示
 * @type switch
 * @default 104
 *
 * @param -------座標設定-------
 * @desc セパレータ
 *
 * @param 横座標
 * @desc ウィンドウ横座標
 * @type switch
 * @default 0
 *
 * @param 縦座標
 * @desc ウィンドウ縦座標
 * @type switch
 * @default 0
 *
 *
 * @help
 *
 * 日付表示プラグインコマンド
 * showDayWindow :表示
 * HideDayWindow :非表示
 *
 */
 
function Game_DayWindow() 
{
    this.initialize.apply(this, arguments);
}

( function() 
{
	var parameters = PluginManager.parameters('DayWindow');
	var param = [];
	
	param.NightMorningSw = Number(parameters['朝夜変更スイッチ'] || 101);
	param.dayVal = Number( parameters['日付格納変数'] || 103 );
	param.VisibleSw = Number( parameters['日付ウィンドウ表示スイッチ'] || 104 );
	
	param.xPos = Number( parameters['横座標'] || 0 ) ;
	param.yPos = Number( parameters['縦座標'] || 0 ) ;
	 //-----------------------------------------------------------------------------
	// Scene_Map
	//
	var isEnabled = false;
	
	var _Scene_Map_createDisplayObjects = Scene_Map.prototype.createDisplayObjects;
	Scene_Map.prototype.createDisplayObjects = function() 
	{
		_Scene_Map_createDisplayObjects.call(this);
		this.Game_DayWindow();
	};

	//日付ウィンドウの作成
	Scene_Map.prototype.Game_DayWindow = function() {
		this._Game_DayWindow = new Game_DayWindow();
		this.addChild(this._Game_DayWindow);
		
	};
	
	var _Scene_Map_terminate = Scene_Map.prototype.terminate;
	Scene_Map.prototype.terminate = function() {
	if (!SceneManager.isNextScene(Scene_Battle)) {
	  this._Game_DayWindow.hide();
	}
	_Scene_Map_terminate.call(this);
	};

	var _Scene_Map_launchBattle = Scene_Map.prototype.launchBattle;
	Scene_Map.prototype.launchBattle = function() {
		this._Game_DayWindow.hide();
		this.removeChild(this._Game_DayWindow);
		this._Game_DayWindow = null;
		_Scene_Map_launchBattle.call(this);
	};
  
	/*以下ウィンドウ作成処理*/
	
	//日付ウィンドウ
	//-----------------------------------------------------------------------------
	// Game_DayWindow
	//
	function _Game_DayWindow() 
	{
		this.initialize.apply(this, arguments);
	}
	
	Game_DayWindow.prototype = Object.create(Window_Base.prototype);
	Game_DayWindow.prototype.constructor = Game_DayWindow;
	
	Game_DayWindow.prototype.initialize = function() {
	
	/*ウィンドウ描画の為の設定*/
	var wight  = 200;
	var height = 70;
	//var x      = Graphics.boxWidth - wight * 2;//画面右端からwidth * 2引いた位置
	//var y      = 0;
	
	var x      = param.xPos;					//x座標
	var y      = param.yPos;					//Y座標
	
	this._isEnabled = false;
	Window_Base.prototype.initialize.call(this, x, y, wight, height);			//ここで描画
	
	this.openness = 0;		//0は非表示　$gameSystem.isVisibleMapHpGauge() ? 255 : 0;
	this.opacity = 198			//半透明度;
	this.contentsOpacity = 255;
	this._gaugeParams = [];
	
	this._baseX = x;
	this._needFaceRefresh = false;
	this.refresh();
	};
	
	//フレーム更新
	  Game_DayWindow.prototype.update = function() 
	  {
    	Window_Base.prototype.update.call(this);
    	//this.drawText("あい", 0,  0, 44);				//表示文字,描画ウィンドウ内のX,描画ウィンドウ内のy, 表示サイズ
    	//this.drawText("うえ", 0, 30, 44);				//表示文字,描画ウィンドウ内のX,描画ウィンドウ内のy, 表示サイズ
    	var varDayInfo = $gameVariables.value( param.dayVal ) + " 日目";
    	console.log(param.dayVal);
    	var varScene;
    	
    	if( $gameSwitches.value(param.NightMorningSw) )
    		varScene = "  夜";
    	else
    		varScene = "  朝";
    	varDayInfo += varScene;
    	
    	this.contents.clear();							//多分前の描画を消す
    	
    	if (  $gameSwitches.value(param.VisibleSw) )
    	{
    		this.openness = 255;		//0は非表示　$gameSystem.isVisibleMapHpGauge() ? 255 : 0;
    		this.drawText(varDayInfo, 0,  0, 144);
    	}
    	else
    	{
    		this.openness = 0;		//0は非表示　$gameSystem.isVisibleMapHpGauge() ? 255 : 0;
    	}
    }
	// リフレッシュ
	Game_DayWindow.prototype.refresh = function() 
	{
		
	}
	
	var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
	var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
	
	//-----------------------------------------------------------------------------
	// Game_Interpreter
	//
	var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
	Game_Interpreter.prototype.pluginCommand = function(command, args) 
	{
	    _Game_Interpreter_pluginCommand.call(this, command, args);
	    if (command === 'showDayWindow') 
	    {
	       $gameSwitches.setValue(param.VisibleSw, true);
	    } else if (command === 'HideDayWindow') {
	       $gameSwitches.setValue(param.VisibleSw, false);
	      
	    }
  };

})();
